<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\VevsClient;

class VevsPullReservation extends Command
{
    protected $signature = 'vevs:pull {ref_id} {--raw}';
    protected $description = 'Pull a VEVS reservation by ref_id and (optionally) print raw JSON';

    public function handle(): int
    {
        $refId = (string) $this->argument('ref_id');

        try {
            $data = VevsClient::make()->getReservation($refId);
        } catch (\Throwable $e) {
            $this->error($e->getMessage());
            return self::FAILURE;
        }

        if ($this->option('raw')) {
            $this->line(json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
        } else {
            // TODO: upsert into your DB here.
            // Reservation::updateOrCreate(['ref_id' => $refId], mapFromVevs($data));
            $this->info("OK: pulled reservation {$refId}");
        }

        return self::SUCCESS;
    }
}
