<?php

declare(strict_types=1);

namespace App\Enums;

/**
 * Enum: PaymentStatus
 *
 * Centralized source for valid payment status values across the Holds app.
 * Always reference these constants instead of raw strings.
 *
 * Used in: App\Models\Job, Payment, Deposit, etc.
 */
enum PaymentStatus: string
{
    case Pending        = 'pending';
    case RequiresAction = 'requires_action';
    case Authorized     = 'authorized';
    case Captured       = 'captured';
    case Succeeded      = 'succeeded';
    case Failed         = 'failed';
    case Canceled       = 'canceled';
    case Refunded       = 'refunded';

    /**
     * Helper: statuses considered “completed” for payment totals.
     */
    public static function completed(): array
    {
        return [
            self::Succeeded->value,
            self::Captured->value,
        ];
    }

    /**
     * Helper: statuses considered “active holds.”
     */
    public static function activeHold(): array
    {
        return [
            self::Authorized->value,
            self::RequiresAction->value,
        ];
    }
}
