<?php

declare(strict_types=1);

namespace App\Filament\Pages;

use Filament\Pages\Dashboard as BaseDashboard;

// Ops widgets
use App\Filament\Widgets\OpsTodayWidget;
use App\Filament\Widgets\OpsKpisWidget;

// Booking & vehicle widgets
use App\Filament\Widgets\UpcomingMaintenanceTodoList;
use App\Filament\Widgets\UpcomingPickupsTable;
use App\Filament\Widgets\UnpaidJobsTable;

// Payments widgets
use App\Filament\Widgets\PaymentStatsWidget;
use App\Filament\Widgets\PaymentsTrendChart;
use App\Filament\Widgets\PaymentsNeedingActionTable;

class Dashboard extends BaseDashboard
{
    /**
     * Widgets shown on the dashboard.
     */
    public function getWidgets(): array
    {
        return [
            // ROW 0  High-level daily operations snapshot
            OpsTodayWidget::class,

            // ROW 1  Vehicle and maintenance
            UpcomingMaintenanceTodoList::class,

            // ROW 2  Bookings & unpaid work
            UpcomingPickupsTable::class,
            UnpaidJobsTable::class,

            // ROW 3  Financial insights
            PaymentStatsWidget::class,
            PaymentsTrendChart::class,
            OpsKpisWidget::class,

            // ROW 4  Things that need action
            PaymentsNeedingActionTable::class,
        ];
    }

    /**
     * Dashboard layout grid.
     */
    public function getColumns(): int|array
    {
        return [
            'default' => 12,
            'sm'      => 12,
            'md'      => 12,
            'lg'      => 12,
            'xl'      => 12,
            '2xl'     => 12,
        ];
    }

    /**
     * Show dashboard link in sidebar.
     */
    public static function shouldRegisterNavigation(): bool
    {
        return true;
    }

    public static function getNavigationLabel(): string
    {
        return 'My Dashboard';
    }

    public function getTitle(): string
    {
        return 'Dream Drives Dashboard';
    }
}
