<?php

declare(strict_types=1);

namespace App\Filament\Resources\JobResource\RelationManagers;

use App\Filament\Resources\DamageResource;
use Filament\Forms;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DamagesRelationManager extends RelationManager
{
    protected static string $relationship = 'damages';

    protected static ?string $recordTitleAttribute = 'id';

    public function form(Forms\Form $form): Forms\Form
    {
        // Reuse the main DamageResource form schema
        return DamageResource::form($form);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('vehicle.display_name')
                    ->label('Vehicle')
                    ->sortable()
                    ->searchable(),

                TextColumn::make('location')
                    ->badge(),

                TextColumn::make('type')
                    ->badge(),

                TextColumn::make('severity')
                    ->badge(),

                TextColumn::make('repair_status')
                    ->badge(),

                TextColumn::make('found_at')
                    ->dateTime('d M Y H:i'),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make()
                    ->mutateFormDataUsing(function (array $data): array {
                        // Pre-fill the job + vehicle from the parent Job record
                        $parent = $this->getOwnerRecord();

                        $data['job_id'] = $parent->id;

                        if (! isset($data['vehicle_id']) && $parent->vehicle_id) {
                            $data['vehicle_id'] = $parent->vehicle_id;
                        }

                        return $data;
                    }),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}
