<?php

namespace App\Filament\Resources\VehicleResource\Pages;

use App\Filament\Resources\VehicleResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;

class EditVehicle extends EditRecord
{
    protected static string $resource = VehicleResource::class;

    /**
     * Keep the header actions simple – we only want the Delete button here.
     * Maintenance logs are created via the Maintenance relation manager,
     * so we don't duplicate the "New vehicle maintenance log" button.
     */
    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
}
