<?php

declare(strict_types=1);

namespace App\Filament\Resources\VehicleResource\RelationManagers;

use App\Filament\Resources\DamageResource;
use Filament\Forms;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;

class DamagesRelationManager extends RelationManager
{
    protected static string $relationship = 'damages';

    protected static ?string $recordTitleAttribute = 'id';

    public function form(Forms\Form $form): Forms\Form
    {
        // Reuse the main DamageResource form schema
        return DamageResource::form($form);
    }

    public function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('job.reference')
                    ->label('Job')
                    ->sortable()
                    ->searchable(),

                TextColumn::make('location')
                    ->badge(),

                TextColumn::make('type')
                    ->badge(),

                TextColumn::make('severity')
                    ->badge(),

                TextColumn::make('repair_status')
                    ->badge(),

                TextColumn::make('found_at')
                    ->dateTime('d M Y H:i'),
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }
}
