<?php

namespace App\Filament\Widgets;

use App\Models\PaymentHold;
use Filament\Tables;
use Filament\Widgets\TableWidget as Widget;
use Illuminate\Database\Eloquent\Builder;

class ExpiringBondHoldsTable extends Widget
{
    protected static ?string $heading = 'Bond Holds Expiring (48 h)';

    protected function getTableQuery(): Builder
    {
        return PaymentHold::query()
            ->whereNull('captured_at')
            ->whereNull('released_at')
            ->where('next_refresh_at', '<=', now()->addHours(48))
            ->orderBy('next_refresh_at');
    }

    protected function getTableColumns(): array
    {
        return [
            Tables\Columns\TextColumn::make('job_id')->label('Job')->sortable(),
            Tables\Columns\TextColumn::make('amount_cents')->money('nzd')->label('Hold'),
            Tables\Columns\TextColumn::make('authorized_at')->dateTime()->label('Authorized'),
            Tables\Columns\TextColumn::make('next_refresh_at')->since()->label('Refresh In'),
        ];
    }
}
