<?php

namespace App\Filament\Widgets;

use Filament\Widgets\StatsOverviewWidget as Widget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use App\Services\Metrics;

class OpsKpisWidget extends Widget
{
    protected function getStats(): array
    {
        $m = app(Metrics::class);

        return [
            Stat::make('Revenue MTD', $m->revenueMtdFormatted())
                ->description($m->mtdDeltaText())
                ->chart($m->mtdSparkline()),

            Stat::make('Uncollected Balance', $m->accountsReceivableFormatted())
                ->description($m->unpaidCount().' jobs'),

            Stat::make('Fleet Utilization Today', $m->utilizationPercent().' %')
                ->description($m->fleetOutCount().' of '.$m->fleetTotal().' out'),
        ];
    }
}
