<?php

namespace App\Filament\Widgets;

use App\Models\Payment;
use Filament\Tables;
use Filament\Widgets\TableWidget as Widget;
use Illuminate\Database\Eloquent\Builder;

class PaymentsNeedingActionTable extends Widget
{
    protected static ?string $heading = 'Payments Needing Action';

    // ✅ Make this widget full width (matches Filament v3 typing)
    protected int|array|string $columnSpan = 'full';

    /**
     * Query only payments that need action, failed, or disputed.
     */
    protected function getTableQuery(): Builder
    {
        return Payment::query()
            ->whereIn('status', ['requires_action', 'failed', 'disputed'])
            ->latest();
    }

    /**
     * Define table columns.
     */
    protected function getTableColumns(): array
    {
        return [
            Tables\Columns\TextColumn::make('job_id')
                ->label('Job')
                ->sortable()
                ->searchable(),

            Tables\Columns\TextColumn::make('status')
                ->label('Status')
                ->badge()
                ->colors([
                    'warning' => 'requires_action',
                    'danger'  => 'failed',
                    'gray'    => 'disputed',
                ])
                ->sortable(),

            Tables\Columns\TextColumn::make('amount_cents')
                ->label('Amount')
                ->formatStateUsing(fn($state) => $state ? 'NZD ' . number_format($state / 100, 2) : '—')
                ->sortable(),

            Tables\Columns\TextColumn::make('created_at')
                ->label('When')
                ->since()
                ->sortable(),
        ];
    }
}
