<?php

namespace App\Http\Controllers;

use App\Http\Requests\ImportReservationRequest;
use Illuminate\Http\JsonResponse;

class JobReservationImportController extends Controller
{
    /**
     * Handle reservation lookup by external reference and return normalized booking fields.
     */
    public function __invoke(ImportReservationRequest $request): JsonResponse
    {
        $externalRef = $request->validated('external_reference');

        $booking = app(\App\Services\Reservations\Lookup::class)
            ->byExternalReference($externalRef);

        abort_unless($booking, 404, 'Reservation not found.');

        // Normalize the payload for your Job form
        return response()->json([
            'booking' => [
                'external_reference' => $externalRef,
                'customer_id'        => $booking->customer_id ?? null,
                'customer_name'      => $booking->customer->name ?? null,
                'customer_email'     => $booking->customer->email ?? null,
                'start_date'         => optional($booking->start_date)->toDateString() ?? ($booking->start_date ?? null),
                'end_date'           => optional($booking->end_date)->toDateString() ?? ($booking->end_date ?? null),
                'vehicle_id'         => $booking->vehicle_id ?? null,
                'notes'              => $booking->notes ?? null,
                // add any other fields your Job form expects
            ],
        ]);
    }
}
