<?php

// app/Http/Controllers/OpsController.php

namespace App\Http\Controllers;

use App\Models\Job;
use App\Models\Vehicle;
use Illuminate\Http\RedirectResponse;

class OpsController extends Controller
{
    public function markReturned(string $ref_id): RedirectResponse
    {
        $job = Job::where('ref_id', $ref_id)->firstOrFail();
        $job->status = 'completed'; // or 'returned' if you add that
        $job->save();

        $vehicle = $job->vehicle;
        if ($vehicle) {
            $vehicle->needs_cleaning = true;
            $vehicle->save();
        }

        return back()->with('success', "Job {$ref_id} marked returned.");
    }

    public function markCleaned(Vehicle $vehicle): RedirectResponse
    {
        $vehicle->needs_cleaning = false;
        $vehicle->save();

        return back()->with('success', "{$vehicle->display_name} marked cleaned.");
    }
}
