<?php

namespace App\Http\Controllers\Payments;

use App\Http\Controllers\Controller;
use App\Models\Job;
use App\Models\Deposit;
use App\Services\StripeService;
use Illuminate\Http\Request;

class PaymentIntentController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'job_id' => ['required','integer','exists:jobs,id'],
            'mode'   => ['required','in:charge,hold,charge+hold'],
        ]);

        $job = Job::findOrFail($data['job_id']);
        $stripe = \App\Services\StripeService::make();

        if ($data['mode'] === 'hold') {
            $deposit = Deposit::firstOrCreate(
                ['job_id' => $job->id, 'type' => 'booking_deposit', 'status' => 'pending'],
                ['amount_cents' => (int)$job->hold_cents]
            );
            $pi = $stripe->createManualCapturePI([
                'amount_cents' => (int)$job->hold_cents,
                'currency' => 'nzd',
                'setup_future_usage' => 'off_session',
                'metadata' => [
                    'kind' => 'deposit_auth',
                    'deposit_id' => $deposit->id,
                    'job_id' => $job->id,
                    'job_ref' => $job->ref ?? $job->id,
                ],
            ]);
            $deposit->update(['stripe_payment_intent_id' => $pi->id]);
            return response()->json(['client_secret' => $pi->client_secret]);
        }

        // For brevity, implement your normal charge PI path here
        // return response()->json(['client_secret' => $pi->client_secret]);
    }
}
