<?php

namespace App\Http\Controllers\Payments;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Services\StripeService;
use Illuminate\Http\Request;

class StripeSyncController extends Controller
{
    public function syncDeposit(Deposit $deposit)
    {
        if (!$deposit->stripe_payment_intent_id) {
            return response()->json(['error' => 'No Stripe PaymentIntent linked.'], 400);
        }

        $stripe = \App\Services\StripeService::make();
        $pi = $stripe->stripe->paymentIntents->retrieve($deposit->stripe_payment_intent_id, []);

        $newStatus = match ($pi->status) {
            'requires_payment_method' => 'pending',
            'requires_confirmation'   => 'pending',
            'requires_action'         => 'requires_action',
            'processing'              => 'processing',
            'requires_capture'        => 'requires_capture',
            'succeeded'               => 'captured',
            'canceled'                => 'released',
            default                   => 'unknown',
        };

        if ($deposit->status !== $newStatus) {
            $deposit->update(['status' => $newStatus]);
        }

        return response()->json([
            'stripe_status' => $pi->status,
            'local_status'  => $deposit->status,
            'matched'       => $deposit->status === $newStatus,
        ]);
    }
}
