<?php
namespace App\Http\Controllers\Payments;

use App\Http\Controllers\Controller;
use App\Models\WebhookEvent;
use Illuminate\Http\Request;

class WebhookController extends Controller
{
    public function receive(Request $request, string $provider)
    {
        $payload = $request->all();
        WebhookEvent::create([
            'provider'          => $provider,
            'provider_event_id' => $payload['id'] ?? ($payload['TxnId'] ?? null),
            'normalized_type'   => $payload['type'] ?? null,
            'raw'               => $payload,
        ]);
        return response()->json(['ok' => true]);
    }
}
