<?php
// app/Http/Controllers/PublicPaymentController.php

namespace App\Http\Controllers;

use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class PublicPaymentController extends Controller
{
    public function show(string $token)
    {
        $p = Payment::where('public_token', $token)->first();
        abort_unless($p, 404);

        // Build a list of temporary public URLs for attachments (if using private disk)
        $attachments = $p->attachments()->get()->map(function ($a) {
            $disk = $a->disk ?? config('filesystems.default');
            $url  = Storage::disk($disk)->temporaryUrl($a->path, now()->addMinutes(30));
            return ['name' => $a->original_name ?: basename($a->path), 'url' => $url];
        });

        // If you prefer to self-host card entry instead of Stripe Checkout, render a payment element here.
        return view('payments.public.show', compact('p', 'attachments'));
    }

    public function thanks(string $token)
    {
        $p = Payment::where('public_token', $token)->first();
        abort_unless($p, 404);
        return view('payments.public.thanks', compact('p'));
    }

    public function cancel(string $token)
    {
        $p = Payment::where('public_token', $token)->first();
        abort_unless($p, 404);
        return view('payments.public.cancel', compact('p'));
    }
}
