<?php

namespace App\Http\Controllers\Webhooks;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SendgridWebhookController extends Controller
{
    public function handle(Request $request)
    {
        // SendGrid posts an array of events
        $events = $request->all();

        Log::info('SendGrid webhook received', [
            'event_count' => is_array($events) ? count($events) : 0,
        ]);

        // TODO: map events to CommunicationEvent rows, etc.
        return response()->json(['ok' => true]);
    }
}
