<?php

namespace App\Listeners;

use Illuminate\Mail\Events\MessageSent;
use Illuminate\Support\Facades\Log;

class LogMailSent
{
    public function handle(MessageSent $event): void
    {
        // Symfony SentMessage is available on $event->sent (Laravel 10+)
        $messageId = method_exists($event->sent ?? null, 'getMessageId')
            ? $event->sent->getMessageId()
            : null;

        // Addresses
        $to   = array_map(fn($a) => method_exists($a,'getAddress') ? $a->getAddress() : (string)$a, $event->message->getTo() ?? []);
        $from = array_map(fn($a) => method_exists($a,'getAddress') ? $a->getAddress() : (string)$a, $event->message->getFrom() ?? []);
        $subj = $event->message->getSubject();

        Log::info('mail.transport.accepted', [
            'message_id' => $messageId,
            'subject'    => $subj,
            'to'         => $to,
            'from'       => $from,
            'mailer'     => config('mail.default'),
        ]);
    }
}
