<?php

namespace App\Mail;

use App\Models\Deposit;
use App\Models\Job;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DepositReleasedMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public Job $job, public Deposit $deposit) {}

    public function build()
    {
        return $this->subject('Security hold released for your booking')
            ->markdown('mail.deposit_released', [
                'job'     => $this->job,
                'deposit' => $this->deposit,
            ]);
    }
}
