<?php

declare(strict_types=1);

namespace App\Mail;

use App\Models\Deposit;
use App\Models\Job;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class HoldReleasedMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public function __construct(
        public Deposit $deposit,
        public Job $job,
        public ?string $brandName = null
    ) {}

    public function build(): self
    {
        $brand = $this->brandName ?? ($this->job->brand->name ?? config('app.name'));
        $amount = number_format(($this->deposit->authorized_cents ?? 0) / 100, 2);

        return $this->subject('Your payment hold has been released')
            ->view('emails.holds.released')
            ->with([
                'customer_name' => $this->job->customer_name ?? 'there',
                'brand_name'    => $brand,
                'amount'        => $amount,
                'currency'      => $this->deposit->currency ?? 'NZD',
                'job_reference' => $this->job->external_reference ?? ('JOB-'.$this->job->id),
                'vehicle_name'  => optional($this->job->vehicle)->name ?? 'Your vehicle',
                'released_at'   => now()->format('Y-m-d H:i'),
                'support_email' => config('mail.from.address'),
            ]);
    }
}
