<?php

namespace App\Mail;

use App\Models\Job;
use App\Models\Payment;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Receipt extends Mailable
{
    use Queueable, SerializesModels;

    public Job $job;
    public Payment $payment;
    public int $amountCents;
    public string $currency;

    public function __construct(Job $job, Payment $payment)
    {
        $this->job = $job;
        $this->payment = $payment;

        // robust amount/currency derivation without assuming job columns
        $this->amountCents = (int) ($payment->amount_cents ?? $payment->amount ?? 0);
        $this->currency    = strtoupper($payment->currency ?? 'NZD');
    }

    public function build()
    {
        return $this
            ->from(config('mail.from.address'), config('mail.from.name'))
            ->subject('Payment receipt — Job #'.$this->job->id)
            ->view('emails.receipt', [
                'job'         => $this->job,
                'payment'     => $this->payment,
                'amountCents' => $this->amountCents,
                'currency'    => $this->currency,
            ]);
    }
}
