<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Communication extends Model
{
    protected $fillable = [
        'job_id','booking_id','channel','type','to_email','from_email','subject','body',
        'status','provider','provider_message_id','headers','meta',
        'sent_at','delivered_at','opened_at','bounced_at','error',
    ];

    protected $casts = [
        'headers'      => 'array',
        'meta'         => 'array',
        'sent_at'      => 'datetime',
        'delivered_at' => 'datetime',
        'opened_at'    => 'datetime',
        'bounced_at'   => 'datetime',
    ];

    public function job(): BelongsTo
    {
        return $this->belongsTo(Job::class);
    }

    public function booking(): BelongsTo
    {
        return $this->belongsTo(Booking::class);
    }
}
