<?php

declare(strict_types=1);

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class OwnerPayout extends Model
{
    protected $fillable = [
        'owner_id',
        'amount_cents',
        'currency_code',
        'payout_method',
        'reference',
        'paid_at',
    ];

    protected $casts = [
        'paid_at' => 'datetime',
    ];

    public function owner(): BelongsTo
    {
        return $this->belongsTo(Owner::class);
    }

    public function ledgerEntries(): HasMany
    {
        return $this->hasMany(OwnerLedgerEntry::class, 'payout_id');
    }
}
