<?php

declare(strict_types=1);

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentHold extends Model
{
    use HasFactory;

    protected $table = 'payment_holds';   // make sure this matches your DB table
    protected $fillable = [
        'job_id',
        'amount_cents',
        'authorized_at',
        'next_refresh_at',
        'captured_at',
        'released_at',
    ];

    protected $casts = [
        'authorized_at'   => 'datetime',
        'next_refresh_at' => 'datetime',
        'captured_at'     => 'datetime',
        'released_at'     => 'datetime',
    ];
}
