<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class PaymentLink extends Model
{
    // Keep it simple; rely on guarded to allow mass-assign
    protected $guarded = [];
    protected $casts = ['expires_at' => 'datetime'];

    public function payment()
    {
        return $this->belongsTo(Payment::class);
    }

    protected static function booted(): void
    {
        static::creating(function (PaymentLink $link) {
            // Public token if missing
            if (empty($link->public_token)) {
                // 64-char hex token (32 bytes)
                $link->public_token = bin2hex(random_bytes(32));
            }

            // Tenant id if missing — prefer the payment's tenant, then current tenant()
            if (empty($link->tenant_id)) {
                $tenantId =
                    ($link->payment && !empty($link->payment->tenant_id))
                        ? $link->payment->tenant_id
                        : (function_exists('tenant') && tenant() ? tenant()->id : null);

                if ($tenantId) {
                    $link->tenant_id = $tenantId;
                }
            }
        });
    }
}
