<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PricingDecision extends Model
{
    protected $fillable = [
        'brand',
        'vehicle_id',
        'vehicle_type',
        'pickup_at',
        'return_at',
        'daily_rate_cents',
        'total_cents',
        'source',
        'context',
    ];

    protected $casts = [
        'pickup_at'        => 'datetime',
        'return_at'        => 'datetime',
        'daily_rate_cents' => 'integer',
        'total_cents'      => 'integer',
        'context'          => 'array',
    ];
}
