<?php

declare(strict_types=1);

namespace App\Observers;

use App\Models\Booking;
use App\Models\Job;

class BookingObserver
{
    public function created(Booking $booking): void
    {
        // Don’t double-create if one already exists for this booking
        $alreadyHasJob = Job::where('booking_id', $booking->id)->exists();

        if ($alreadyHasJob) {
            return;
        }

        Job::create([
            'booking_id'        => $booking->id,
            'brand'             => $booking->brand,
            'customer_id'       => $booking->customer_id,
            'start_at'          => $booking->start_at,
            'end_at'            => $booking->end_at,
            'currency'          => $booking->currency ?? 'NZD',
            'charge_amount_cents' => $booking->total_amount,
            'required_deposit'    => $booking->deposit_amount,
            'security_deposit'    => $booking->hold_amount,
            'status'            => 'pending',
        ]);
    }
}
