<?php

namespace App\Observers;

use App\Models\Payment;

class PaymentObserver
{
    /**
     * Fired after a Payment is created or updated.
     */
    public function saved(Payment $payment): void
    {
        $payment->job?->recalcTotalsFromPayments();
    }

    /**
     * Fired after a Payment is deleted.
     */
    public function deleted(Payment $payment): void
    {
        $payment->job?->recalcTotalsFromPayments();
    }
}
