<?php
namespace App\Payments;

use App\Payments\DTOs\CreatePaymentDto;

interface PaymentProvider
{
    public function key(): string; // 'stripe'|'windcave'
    public function createPaymentIntent(CreatePaymentDto $dto): ProviderInitResponse;
    public function retrieve(string $providerPaymentId): ProviderPaymentState;
    public function refund(string $providerChargeId, int $amount, ?string $reason = null): ProviderResult;
}

class ProviderInitResponse {
    public function __construct(public string $id, public string $redirectUrl, public array $raw = []) {}
}
class ProviderPaymentState {
    public function __construct(
        public string $status,
        public ?string $chargeId = null,
        public ?string $settlementRef = null,
        public ?string $errorCode = null,
        public ?string $errorMessage = null,
        public array $raw = [],
    ) {}
}
class ProviderResult {
    public function __construct(public bool $ok, public ?string $id = null, public ?string $message = null, public array $raw = []) {}
}
