<?php
namespace App\Payments;

use App\Payments\Providers\StripeProvider;
use App\Payments\Providers\WindcaveProvider;

class ProviderResolver
{
    public function __construct(protected array $config = [])
    {
        $this->config = config('payments.providers');
    }

    public function forTenant($tenant, ?string $force = null): PaymentProvider
    {
        $provider = $force ?: ($tenant->payment_provider ?? 'stripe');
        return match ($provider) {
            'windcave' => new WindcaveProvider($this->config['windcave']),
            default    => new StripeProvider($this->config['stripe']),
        };
    }
}
