<?php
namespace App\Payments\Providers;

use App\Payments\DTOs\CreatePaymentDto;
use App\Payments\{PaymentProvider, ProviderInitResponse, ProviderPaymentState, ProviderResult};

class StripeProvider implements PaymentProvider
{
    public function __construct(protected array $cfg) {}
    public function key(): string { return 'stripe'; }

    public function createPaymentIntent(CreatePaymentDto $dto): ProviderInitResponse
    {
        // TODO: real Stripe Checkout session. Stub for now:
        $id  = 'sess_'.bin2hex(random_bytes(6));
        $url = route('pay.placeholder', ['token' => 'stripe-'.$id]);
        return new ProviderInitResponse($id, $url, ['provider' => 'stripe']);
    }

    public function retrieve(string $providerPaymentId): ProviderPaymentState
    { return new ProviderPaymentState('pending'); }

    public function refund(string $providerChargeId, int $amount, ?string $reason = null): ProviderResult
    { return new ProviderResult(true, 're_'.bin2hex(random_bytes(6))); }
}
