<?php
namespace App\Payments\Providers;

use App\Payments\DTOs\CreatePaymentDto;
use App\Payments\{PaymentProvider, ProviderInitResponse, ProviderPaymentState, ProviderResult};

class WindcaveProvider implements PaymentProvider
{
    public function __construct(protected array $cfg) {}
    public function key(): string { return 'windcave'; }

    public function createPaymentIntent(CreatePaymentDto $dto): ProviderInitResponse
    {
        // TODO: real PX Pay 2.0 initiate. Stub for now:
        $id  = 'px_'.bin2hex(random_bytes(6));
        $url = route('pay.placeholder', ['token' => 'windcave-'.$id]);
        return new ProviderInitResponse($id, $url, ['provider' => 'windcave']);
    }

    public function retrieve(string $providerPaymentId): ProviderPaymentState
    { return new ProviderPaymentState('pending'); }

    public function refund(string $providerChargeId, int $amount, ?string $reason = null): ProviderResult
    { return new ProviderResult(true, 'wr_'.bin2hex(random_bytes(6))); }
}
