<?php

declare(strict_types=1);

namespace App\Policies;

use App\Models\User;

class UserPolicy
{
    public function before(?User $authUser, string $ability): ?bool
    {
        // Short-circuit: admins can do everything in this policy.
        return $authUser?->isAdmin() ? true : null;
    }

    public function viewAny(User $authUser): bool { return true; }
    public function view(User $authUser, User $model): bool { return true; }
    public function create(User $authUser): bool { return true; }
    public function update(User $authUser, User $model): bool { return true; }
    public function delete(User $authUser, User $model): bool { return true; }
}
