<?php

declare(strict_types=1);

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Livewire\Livewire;

// Models
use App\Models\Job;
use App\Models\VehicleMaintenanceLog;

// Observers
use App\Observers\JobObserver;
use App\Observers\VehicleMaintenanceLogObserver;

// Widgets
use App\Filament\Widgets\UpcomingMaintenanceByVehicle;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        // Place service container bindings or singletons here if needed.
    }

    public function boot(): void
    {
        $this->registerObservers();
        $this->registerLivewireComponents();
    }

    /**
     * Register model observers used throughout the application.
     */
    protected function registerObservers(): void
    {
        VehicleMaintenanceLog::observe(VehicleMaintenanceLogObserver::class);
        Job::observe(JobObserver::class);
    }

    /**
     * Register Livewire components used by Filament widgets.
     */
    protected function registerLivewireComponents(): void
    {
        Livewire::component(
            'app.filament.widgets.upcoming-maintenance-by-vehicle',
            UpcomingMaintenanceByVehicle::class
        );
    }
}
