<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use App\Listeners\SendPaymentReceiptListener;

class EventServiceProvider extends ServiceProvider
{
    
    protected $listen = [
    \Illuminate\Mail\Events\MessageSent::class => [
        \App\Listeners\LogMailSent::class,
    ],
    
    \App\Events\PaymentCaptured::class => [
        \App\Listeners\SendPaymentReceiptListener::class,
    ],
];


    public function boot(): void
    {
        //
    }
}
