<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Holds\Api\V1\HoldsApiController;
use App\Domain\Holds\Services\Contracts\HoldGateway;

class RouteServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        // Web routes
        Route::middleware('web')->group(base_path('routes/web.php'));

        // API routes
        Route::prefix('api')->middleware('api')->group(base_path('routes/api.php'));

        // Optional: HOLDS web routes
        if (file_exists(base_path('routes/holds_web.php'))) {
            Route::middleware('web')->group(base_path('routes/holds_web.php'));
        }

        // Optional: HOLDS api routes (this file already defines its own /api/v1 prefix)
        if (file_exists(base_path('routes/holds_api.php'))) {
            // Guard the inclusion so route:list doesn’t try to resolve unbound services.
            if (class_exists(HoldsApiController::class) && app()->bound(HoldGateway::class)) {
                require base_path('routes/holds_api.php');
            }
        }
    }
}
