<?php

declare(strict_types=1);

namespace App\Services;

use App\Models\Job;

class OwnerEarningsCalculator
{
    public function calculate(Job $job): int
    {
        // no consignment – nothing owed
        if (! $job->hasConsignmentOwner()) {
            return 0;
        }

        $base   = (int) ($job->base_rental_cents ?? 0);
        $extraKm = (int) ($job->extra_mileage_fee_cents ?? 0);

        // overrides
        if ($job->owner_share_mode === 'fixed_amount') {
            $ownerBase = (int) $job->owner_fixed_amount_cents;
        } elseif ($job->owner_share_mode === 'custom_percent') {
            $percent   = (int) ($job->owner_share_percent_override ?? 0);
            $ownerBase = (int) floor($base * $percent / 100);
        } else {
            // global model: 50% of base rental
            $ownerBase = (int) floor($base * 0.5);
        }

        $ownerKm = $extraKm; // 100% of extra km fee

        return max(0, $ownerBase + $ownerKm);
    }
}
