<?php

namespace App\Services\Payments;

use App\Models\Payment;
use App\Services\Payments\Gateways\StripeGateway;
use App\Services\Payments\Gateways\WindcaveGateway;

class GatewayManager
{
    public function __construct(private array $config) {}

    /** Pick the driver for a given payment (override chain). */
    public function forPayment(Payment $p): PaymentGateway
    {
        // Override order: payment.provider -> flow/tenant (TODO) -> config default
        $driver = $p->provider ?: ($this->config['default'] ?? 'stripe');

        return $this->driver($driver);
    }

    public function driver(string $driver): PaymentGateway
    {
        $drivers = $this->config['drivers'] ?? [];

        return match ($driver) {
            'stripe'   => new StripeGateway($drivers['stripe'] ?? []),
            'windcave' => new WindcaveGateway($drivers['windcave'] ?? []),
            default    => throw new \InvalidArgumentException("Unknown payments driver: {$driver}"),
        };
    }
}
