<?php

namespace App\Services;

use Stripe\StripeClient;

class StripeService
{
    public function __construct(private StripeClient $stripe) {}

    public static function make(): self
    {
        return new self(new StripeClient(config('services.stripe.secret')));
    }

    public function createManualCapturePI(array $params): \Stripe\PaymentIntent
    {
        $base = [
            'amount' => $params['amount_cents'],
            'currency' => $params['currency'] ?? 'nzd',
            'capture_method' => 'manual',
            'confirmation_method' => 'automatic',
            'metadata' => $params['metadata'] ?? [],
        ];

        if (!empty($params['customer'])) {
            $base['customer'] = $params['customer'];
        }

        if (!empty($params['payment_method'])) {
            $base['payment_method'] = $params['payment_method'];
        }

        if (!empty($params['setup_future_usage'])) {
            // e.g. 'off_session'
            $base['payment_method_options']['card']['setup_future_usage'] = $params['setup_future_usage'];
        }

        return $this->stripe->paymentIntents->create($base);
    }
}
