<?php

declare(strict_types=1);

namespace App\Services;

use RuntimeException;

class VevsClientFactory
{
    public function forBrandKey(?string $brandKey = null): VeVsApi
    {
        $root     = config('services.vevs', []);
        $brandKey = $brandKey ?: ($root['default_connection'] ?? 'jimny');

        // Prefer brand-specific config
        $brandConfig = $root[$brandKey] ?? null;

        if (! $brandConfig) {
            throw new RuntimeException("No VEVS config found for brand [{$brandKey}].");
        }

        $baseUrl = rtrim((string) ($brandConfig['base_url'] ?? ''), '/');
        $token   = (string) ($brandConfig['token'] ?? '');
        $timeout = (int) ($root['timeout'] ?? 20);

        if ($baseUrl === '' || $token === '') {
            throw new RuntimeException("VEVS base URL or token not configured for brand [{$brandKey}].");
        }

        return new VeVsApi(
            baseUrl: $baseUrl,
            token:   $token,
            timeout: $timeout,
        );
    }
}
