<?php

namespace App\Support\Sanitize;

final class VevsReservation
{
    public static function redact(array $res): array
    {
        $removeExact = [
            'c_email','c_phone','c_licence','c_licence_2','signed_data',
            'c_address','c_city','c_state','c_zip','c_country','c_dob','c_dob_2',
        ];

        foreach ($removeExact as $k) unset($res[$k]);

        // Remove uploaded file paths/names/types (c_file_path, c_file_name, ... with suffixes)
        foreach ($res as $k => $_) {
            if (preg_match('/^c_file_(path|type|name)(_?\d+)?$/', $k)) unset($res[$k]);
        }

        return $res;
    }
}
