<?php
namespace App\Support;
use App\Models\Payment;

function resolve_amount_cents(Payment $p): int {
    // Prefer amount_cents; else derive from amount (assumed dollars)
    if (!empty($p->amount_cents)) return (int) $p->amount_cents;
    if (!empty($p->amount))      return (int) round(((float) $p->amount) * 100);
    return 0;
}
