<?php
// app/helpers.php

if (! function_exists('currency_nzd')) {
    /**
     * Format a New Zealand Dollar amount from CENTS.
     *
     * Examples:
     *   currency_nzd(1234)   → "NZ$ 12.34"
     *   currency_nzd(null)   → "NZ$ 0.00"
     */
    function currency_nzd(int|float|null $amountCents): string
    {
        if ($amountCents === null) {
            return 'NZ$ 0.00';
        }

        $amount = ((int) $amountCents) / 100;

        // Prefer intl if available
        if (class_exists(\NumberFormatter::class)) {
            $fmt = new \NumberFormatter('en_NZ', \NumberFormatter::CURRENCY);
            $out = $fmt->formatCurrency($amount, 'NZD');
            if ($out !== false) {
                return $out;
            }
        }

        // Fallback when intl missing or fails
        return 'NZ$ ' . number_format($amount, 2, '.', ',');
    }
}
