<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Defaults
    |--------------------------------------------------------------------------
    */
    'defaults' => [
        'guard' => env('AUTH_GUARD', 'web'),
        'passwords' => env('AUTH_PASSWORD_BROKER', 'users'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Authentication Guards (session only)
    |--------------------------------------------------------------------------
    */
    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        // Portal guard (for your customer portal)
        'portal' => [
            'driver' => 'session',
            'provider' => 'customers', // links to Customer model
        ],

        // Optional: legacy guard if you ever still use it
        // 'customer' => [
        //     'driver' => 'session',
        //     'provider' => 'customers',
        // ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Providers
    |--------------------------------------------------------------------------
    */
    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model'  => App\Models\User::class,
        ],

        // Customers (used by the portal guard)
        'customers' => [
            'driver' => 'eloquent',
            'model'  => App\Models\Customer::class,
        ],

        // Optional: if you keep PortalUser model for something else
        // 'portal_users' => [
        //     'driver' => 'eloquent',
        //     'model'  => App\Models\PortalUser::class,
        // ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Reset Config
    |--------------------------------------------------------------------------
    */
    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table'    => env('AUTH_PASSWORD_RESET_TOKEN_TABLE', 'password_reset_tokens'),
            'expire'   => 60,
            'throttle' => 60,
        ],

        // Optional: if you later want reset support for customers
        // 'customers' => [
        //     'provider' => 'customers',
        //     'table'    => 'customer_password_reset_tokens',
        //     'expire'   => 60,
        //     'throttle' => 60,
        // ],
    ],

    'password_timeout' => env('AUTH_PASSWORD_TIMEOUT', 10800),
];
