<?php

return [
    'default' => env('MAIL_MAILER', 'sendgrid'),

    'mailers' => [
        // SendGrid via Symfony Mailer DSN
        'sendgrid' => [
            'transport' => 'symfony',
            'dsn'       => env('MAIL_DSN'), // e.g. sendgrid+api://<KEY>@default
        ],

        'smtp' => [
            'transport'    => 'smtp',
            'host'         => env('MAIL_HOST', 'smtp.sendgrid.net'),
            'port'         => env('MAIL_PORT', 2525),
            'username'     => env('MAIL_USERNAME', 'apikey'),
            'password'     => env('MAIL_PASSWORD'),
            'encryption'   => env('MAIL_ENCRYPTION', 'tls'),
            'timeout'      => null,
            'local_domain' => env('MAIL_EHLO_DOMAIN', parse_url((string) env('APP_URL', 'http://localhost'), PHP_URL_HOST)),
        ],

        'log'   => ['transport' => 'log'],
        'array' => ['transport' => 'array'],

        'failover' => [
            'transport'   => 'failover',
            'mailers'     => ['sendgrid', 'log'],
            'retry_after' => 60,
        ],
    ],

    'from' => [
        'address' => env('MAIL_FROM_ADDRESS', 'adam@dreamdrives.co.nz'),
        'name'    => env('MAIL_FROM_NAME', 'Dream Drives / Jimny NZ'),
    ],

    'markdown' => [
        'theme' => 'default',
        'paths' => [resource_path('views/vendor/mail')],
    ],
];