<?php

return [
    'default' => env('PAYMENTS_DRIVER', 'stripe'),

    // Per-tenant/flow overrides are easy: write a resolver (see GatewayManager)
    'drivers' => [
        'stripe' => [
            'publishable' => env('STRIPE_KEY'),
            'secret'      => env('STRIPE_SECRET'),
        ],
        'windcave' => [
            // PxPay 2.0
            'user_id'     => env('WINDCAVE_PXPAY_USERID'),
            'key'         => env('WINDCAVE_PXPAY_KEY'),
            // where Windcave will send the shopper back:
            'return_url'  => env('APP_URL') . '/pay/windcave/return',
            // optional: notification URL (server-to-server)
            'notify_url'  => env('APP_URL') . '/pay/windcave/notify',
        ],
    ],
];
