<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Base daily rates (in cents)
    |--------------------------------------------------------------------------
    */

    'jimny' => [
        'jimny_3door' => 16000, // $160/night
        'jimny_5door' => 18000, // $180/night
    ],

    'dreamdrives' => [
        'default' => 30000, // $300/night fallback
    ],

    /*
    |--------------------------------------------------------------------------
    | Guardrails for daily rate (in cents)
    |--------------------------------------------------------------------------
    */

    'guards' => [
        'min_daily_cents' => 12000,  // $120 minimum
        'max_daily_cents' => 120000, // $1,200 maximum
    ],

    /*
    |--------------------------------------------------------------------------
    | Lead time adjustment rules
    |--------------------------------------------------------------------------
    |
    | Simple brackets: "min_days" / "max_days" (inclusive of min, exclusive of max)
    | with a "multiplier" applied to the base rate.
    */

    'lead_time_rules' => [
        [
            'min_days'   => 0,
            'max_days'   => 2,     // same-day / next-day
            'multiplier' => 1.20,  // +20%
        ],
        [
            'min_days'   => 2,
            'max_days'   => 7,     // within a week
            'multiplier' => 1.10,  // +10%
        ],
        [
            'min_days'   => 7,
            'max_days'   => 30,    // 1–4 weeks
            'multiplier' => 1.00,  // base
        ],
        [
            'min_days'   => 30,
            'max_days'   => 90,    // 1–3 months out
            'multiplier' => 0.95,  // -5%
        ],
        [
            'min_days'   => 90,
            'max_days'   => 365,   // super early
            'multiplier' => 0.90,  // -10%
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Seasonality rules by month
    |--------------------------------------------------------------------------
    |
    | Keyed by month number (1..12) with simple multipliers.
    */

    'seasonality_rules' => [
        // Summer peak (Dec–Feb)
        12 => 1.15, // Dec
        1  => 1.20, // Jan
        2  => 1.15, // Feb

        // Shoulder (Nov, Mar)
        11 => 1.10,
        3  => 1.10,

        // Winter slightly lower (Jun–Aug) for non-ski stuff
        6  => 0.95,
        7  => 0.95,
        8  => 0.95,
    ],
];
