<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    | Central configuration for external services used by the application.
    | All secrets/keys are read from environment variables.
    */

    // ----------------------------------------------------------------------
// VEVS — Multi-brand booking API (Jimny + Dream Drives)
// ----------------------------------------------------------------------
'vevs' => [
    // Run VEVS jobs on the queue?
    'queue' => filter_var(env('VEVS_QUEUE', true), FILTER_VALIDATE_BOOLEAN),

    // HTTP timeout
    'timeout' => max(1, (int) env('VEVS_TIMEOUT', 20)),

    // Default connection when none is provided
    'default_connection' => env('VEVS_DEFAULT_CONNECTION', 'jimny'),

    // Legacy single-brand keys (backwards compat – point at Jimny)
    'base_url' => env('VEVS_BASE_URL', env('VEVS_JIMNY_BASE_URL', 'https://rental.jimny.co.nz')),
    'token'    => env('VEVS_TOKEN', env('VEVS_JIMNY_API_KEY')),

    // Brand-specific configs used by VevsClientFactory
    'jimny' => [
        'base_url' => env('VEVS_JIMNY_BASE_URL', 'https://rental.jimny.co.nz'),
        'token'    => env('VEVS_JIMNY_API_KEY'),
    ],

    'dreamdrives' => [
        'base_url' => env('VEVS_DD_BASE_URL', 'https://www.dreamdrives.co.nz'),
        'token'    => env('VEVS_DD_API_KEY'),
    ],
],


    // ----------------------------------------------------------------------
    // Internal pull API (for secure CRON or integrations)
    // ----------------------------------------------------------------------
    'internal' => [
        'pull_secret' => env('INTERNAL_PULL_SECRET', ''),
    ],


    // ----------------------------------------------------------------------
    // Dream Drives legacy feed (unrelated to VEVS)
    // ----------------------------------------------------------------------
    'dreamdrives' => [
        'base' => env('DREAMDRIVES_FEED_BASE', 'https://api.dreamdrives.example'),
        'key'  => env('DREAMDRIVES_FEED_KEY'),
        'tz'   => env('DREAMDRIVES_DEFAULT_TZ', 'Pacific/Auckland'),
    ],


    // ----------------------------------------------------------------------
    // Email Providers
    // ----------------------------------------------------------------------
    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'ses' => [
        'key'    => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    // ----------------------------------------------------------------------
    // Slack Notifications
    // ----------------------------------------------------------------------
    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel'              => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    // ----------------------------------------------------------------------
    // Payments — Stripe
    // ----------------------------------------------------------------------
    'stripe' => [
        'key'            => env('STRIPE_KEY'),
        'secret'         => env('STRIPE_SECRET'),
        'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
    ],

    // ----------------------------------------------------------------------
    // Magic login links
    // ----------------------------------------------------------------------
    'magic_links' => [
        'secret' => env('MAGIC_LINKS_SECRET'),
    ],

];
