<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Default VeVS Connection
    |--------------------------------------------------------------------------
    |
    | When using the VeVS API client, this connection name will be selected
    | unless another connection is explicitly requested.
    |
    */

    'default_connection' => env('VEVS_DEFAULT_CONNECTION', 'jimny'),

    /*
    |--------------------------------------------------------------------------
    | VeVS Connections
    |--------------------------------------------------------------------------
    |
    | Support multiple VeVS accounts (e.g., Jimny Rentals + Dream Drives).
    |
    | Each connection may be configured in one of two ways:
    |
    | 1) Full API root (full URL including /api/<token>):
    |       VEVS_<NAME>_API_ROOT="https://domain/api/XXXXXXXX"
    |
    | 2) Base URL + token (recommended):
    |       VEVS_<NAME>_BASE_URL="https://domain"
    |       VEVS_<NAME>_TOKEN="XXXXXXXX"
    |
    | The API client should use api_root first if present; otherwise,
    | base_url + token will be used.
    |
    */

    'connections' => [

        'jimny' => [
            // Preferred: full API endpoint such as:
            // https://rental.jimny.co.nz/api/7hNDOb8wBJHC...
            'api_root' => env('VEVS_JIMNY_API_ROOT', ''),

            // Fallback: base host only (no /api/xxxxx part)
            'base_url' => env('VEVS_JIMNY_BASE_URL', 'https://rental.jimny.co.nz'),

            // Fallback API token (only required when api_root is not set)
            'token'    => env('VEVS_JIMNY_TOKEN', ''),

            // Legacy key (not used but kept for compatibility)
            'api_key'  => env('VEVS_JIMNY_API_KEY'),
        ],

            'dreamdrives' => [
        'base_url' => env('VEVS_DD_BASE_URL'),
        'api_key'  => env('VEVS_DD_API_KEY'),
    ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Request Timeout
    |--------------------------------------------------------------------------
    |
    | Timeout in seconds for VeVS API calls.
    |
    */

    'timeout' => env('VEVS_TIMEOUT', 20),

    /*
    |--------------------------------------------------------------------------
    | Endpoint Overrides (Optional)
    |--------------------------------------------------------------------------
    |
    | Normally you should leave these empty. If VeVS ever changes their
    | path structure or you need custom endpoints, you can override them here.
    |
    */

    'endpoints' => [
        // 'cars'           => 'Cars',
        // 'by_ref'         => 'Reservation',
        // 'week_made'      => 'ReservationWeekMade',
        // 'week_pickup'    => 'ReservationWeekPickup',
        // 'made_between'   => '',
        // 'pickup_between' => '',
    ],

];
