<?php

namespace Database\Factories;

use App\Models\Payment;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class PaymentFactory extends Factory
{
    protected $model = Payment::class;

    public function definition(): array
    {
        $types = [
            'booking_deposit',
            'booking_balance',
            'post_hire',
            'bond_hold',
            'bond_capture',
            'refund',
            'other',
        ];
        $statuses  = ['pending','succeeded','failed','canceled'];
        $currencies = ['NZD','AUD','USD','EUR','GBP'];

        $first = ucfirst(Str::lower(Str::random(6)));
        $last  = ucfirst(Str::lower(Str::random(5)));
        $email = Str::lower($first.'.'.$last).'@example.com';

        return [
            'job_id'        => null, // or a valid ID if you want linkage
            'reference'     => strtoupper(Str::random(8)),
            'type'          => $types[array_rand($types)],
            'status'        => $statuses[array_rand($statuses)],
            'mechanism'     => ['card','bank_transfer','cash','other'][array_rand(['card','bank_transfer','cash','other'])],
            // dollars -> cents
            'amount_cents'  => random_int(1500, 125000),
            'currency'      => $currencies[array_rand($currencies)],
            // Stripe refs optional
            'stripe_payment_intent_id' => null,
            'stripe_payment_method_id' => null,
            'stripe_charge_id'         => null,
            // JSON fields expected by your resource
            'details' => [
                'customer_name'  => $first.' '.$last,
                'customer_email' => $email,
                'note'           => 'Seeded payment',
            ],
        ];
    }

    // handy states
    public function succeeded(): static { return $this->state(fn() => ['status' => 'succeeded']); }
    public function pending(): static   { return $this->state(fn() => ['status' => 'pending']); }
    public function failed(): static    { return $this->state(fn() => ['status' => 'failed']); }
    public function canceled(): static  { return $this->state(fn() => ['status' => 'canceled']); }

    public function deposit(): static   { return $this->state(fn() => ['type' => 'booking_deposit']); }
    public function balance(): static   { return $this->state(fn() => ['type' => 'booking_balance']); }
    public function postHire(): static  { return $this->state(fn() => ['type' => 'post_hire']); }
    public function bondHold(): static  { return $this->state(fn() => ['type' => 'bond_hold']); }
}
