<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Idempotent + guarded
        if (! Schema::hasColumn('vehicles', 'needs_cleaning')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->boolean('needs_cleaning')
                    ->default(false);
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('vehicles', 'needs_cleaning')) {
            Schema::table('vehicles', function (Blueprint $table) {
                $table->dropColumn('needs_cleaning');
            });
        }
    }
};
